#include <xc.h>
#include <stdint.h>
#include <string.h>
#include <pic12f1572.h>

#include "memory.h"
#include "color.h"

// CONFIG1
#pragma config FOSC = INTOSC	//  (INTOSC oscillator; I/O function on CLKIN pin)
#pragma config WDTE = OFF		// Watchdog Timer Enable (WDT disabled)
#pragma config PWRTE = ON		// Power-up Timer Enable (PWRT enabled)
#pragma config MCLRE = OFF		// MCLR Pin Function Select (MCLR/VPP pin function is digital input)
#pragma config CP = OFF			// Flash Program Memory Code Protection (Program memory code protection is disabled)
#pragma config BOREN = ON		// Brown-out Reset Enable (Brown-out Reset enabled)
#pragma config CLKOUTEN = OFF	// Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)

// CONFIG2
#pragma config WRT = OFF		// Flash Memory Self-Write Protection (Write protection off)
#pragma config PLLEN = ON		// PLL Enable (4x PLL enabled)
#pragma config STVREN = ON		// Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
#pragma config BORV = LO		// Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
#pragma config LPBOREN = OFF	// Low Power Brown-out Reset enable bit (LPBOR is disabled)
#pragma config DEBUG = OFF		// In-Circuit Debugger Mode (In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins)
#pragma config LVP = OFF		// Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)

#define _XTAL_FREQ	32000000	// 32MHz
#define	MON			LATA4
#define	CHCHG		0xff		// `lύXR[h

//#define	DEBUG

volatile uint8_t	dtbuf[6],dtbufb[6];
volatile uint8_t	rxcnt = 0;
volatile uint8_t	receiving = 0;
volatile uint8_t	recend = 0;
volatile uint16_t	timer1_count = 0;
uint16_t	chChar = 0;			// chobt@ 0:0x60?31:0x7f
uint16_t	ramBuf[16];

const uint8_t decode_table_const[256] = {	// 7B8Btϊe[u
	0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  1,  2,  0,  3,  4,  5,  0,  6,  7,  8,  0,  0,  9, 10,  0, 11, 12, 13,  0, 14, 15, 16,  0, 17, 18, 19,
	0,  0,  0,  0,  0,  0,  0,  0,  0, 20, 21, 22,  0, 23, 24, 25,  0,  0, 26, 27,  0, 28, 29, 30,  0, 31, 32, 33,  0, 34, 35, 36,
	0,  0,  0,  0,  0, 37, 38, 39,  0, 40, 41, 42,  0, 43, 44, 45,  0,  0, 46, 47,  0, 48, 49, 50,  0, 51, 52, 53,  0, 54, 55, 56,
	0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57, 58,  0, 59, 60, 61,  0, 62, 63, 64,  0, 65, 66, 67,
	0,  0,  0,  0,  0, 68, 69, 70,  0, 71, 72, 73,  0, 74, 75, 76,  0,  0, 77, 78,  0, 79, 80, 81,  0, 82, 83, 84,  0, 85, 86, 87,
	0,  0,  0,  0,  0,  0,  0,  0,  0, 88, 89, 90,  0, 91, 92, 93,  0,  0, 94, 95,  0, 96, 97, 98,  0, 99,100,101,  0,102,103,104,
	0,  0,  0,  0,  0,105,106,107,  0,108,109,110,  0,111,112,113,  0,  0,114,115,  0,116,117,118,  0,119,120,121,  0,122,123,124
};

void reset_buffer(void) {
	rxcnt = 0;
	receiving = 0;
	TMR1H = 0;
	TMR1L = 0;
	PIR1bits.TMR1IF = 0;
	T1CONbits.TMR1ON = 0;
}

void __interrupt() isr(void) {
	static uint8_t	leng=3;	// MoCgi[

	// UARTM荞 擪R[hŁAM35
	if (PIR1bits.RCIF) {
		PIR1bits.TMR1IF = 0;
//		MON = 1;
//		TXREG = rx;	// for debug
		if (RCSTAbits.OERR) {		// I[o[G[΍
			RCSTAbits.CREN = 0;
			RCSTAbits.CREN = 1;
			reset_buffer();
			return;
		}
		uint8_t rx = decode_table_const[RCREG];  // decodeςݎMf[^
		if (receiving==0) {
			receiving = 1;
			TMR1 = 64536;
			T1CONbits.TMR1ON = 1;
			if((rx & 0x40)!=0) {	// 擪R[hbit6=1M:3Aelse M:5
				leng = 3;
			} else {
				leng = 5;
			}
		}
		dtbuf[rxcnt] = rx;
		if (++rxcnt >= leng) {		// lenoCgM
			T1CONbits.TMR1ON = 0;	// ^C}[~
			receiving = 0;
			rxcnt = 0;
			memcpy((void *)dtbufb,(const void *)dtbuf,leng);
			recend = 1;
		}
//		MON = 0;
	}
	// ^C}[1荞݁i1msȓ4byteMŁAMZbgj
	if (PIR1bits.TMR1IF) {
		PIR1bits.TMR1IF = 0;
		reset_buffer();
	}
}

// N`lf[^ǂݏo
void readEEPROM() {
	uint16_t dt = FLASH_ReadWord(0x0780);
	if((dt>0x7f) || (dt<0)) {
		FLASH_WriteWord(0x0780,ramBuf,0x0);
		dt = 0x60;
	}
	chChar = dt;
}

// `lf[^
void writeEEPROM(uint16_t dt) {
	FLASH_WriteWord(0x0780,ramBuf,dt);
}

// 7B8B畜(e[ułƒvZ)
uint8_t decode_7b8b(uint8_t code) {	// tϊe[ugfR[_[
	return decode_table_const[code];
}

#define	VOFF1	4095
#define	VOFF2	8191
#define	PERIOD	12288

void main() {
	OSCCON	= 0b01110000;		// INTOSC,32MHz
	OPTION_REGbits.nWPUEN = 0;  // ̓s̃vAbv
	// port init
	ANSELA	= 0b00000000;		// No Analog
	LATA	= 0b00000111;		// 
	TRISA	= 0b00100000;		// RA5:in other:out
	WPUA	= 0b00000000;
	__delay_ms(200);
	// Timer1 init
	T1CON = 0b00110001;			// Fosc/4 = 8MHz, 1:8vXP[, TMR1 ON
	TMR1 = 0;
	PIE1bits.TMR1IE = 1;		// Timer1荞ݗL
	PIR1bits.TMR1IF = 0;
	readEEPROM();			//@`lf[^ǂݏo
	// PWM init:DutyMax:1/3ɂRGBϓɔzu(ePeriod:16384)
	PWM1CLKCON = 0x00;		// 1/16,FOSC
	PWM1PR = PERIOD;			// 65536*3/4
	PWM1PH = 0;				// phase:0
	PWM1DC = 0;
	PWM1LDCONbits.LDA = 1;	// Load OF, PH, DC, and PR buffers
	PWM1CON = 0b11010000 ;	// On,OE,Out,Neg,NormPWM
	PWM2CLKCON = 0x00;		// 1/16,FOSC
	PWM2PR = PERIOD;			// 65536*3/4
	PWM2PH = VOFF1;			// phase:1/3period
	PWM2DC = VOFF1;
	PWM2LDCONbits.LDA = 1;	// Load OF, PH, DC, and PR buffers
	PWM2CON = 0b11010000 ;	// On,OE,Out,Neg,NormPWM
	PWM3CLKCON = 0x00;		// 1/16,FOSC
	PWM3PR = PERIOD;			// 65536*3/4
	PWM3PH = VOFF2;			// phase:2/3period
	PWM3DC = VOFF2;
	PWM3LDCONbits.LDA = 1;	// Load OF, PH, DC, and PR buffers
	PWM3CON = 0b11010000 ;	// On,OE,Out,Neg,NormPWM
	// UART init
	BAUDCONbits.BRG16 = 1;	// 57600bps ݒiBRG16 = 1, BRGH = 1j
#ifdef	DEBUG
	TXSTAbits.TXEN = 1;		// fobÔTxL for debug
	APFCONbits.TXCKSEL = 1;	// Tx:RA4(փ|[g)
#endif
	TXSTAbits.SYNC = 0;
	TXSTAbits.BRGH = 1;
	SPBRG = 138;
	APFCONbits.RXDTSEL = 1;	// Rx:RA5(փ|[g)
	RCSTAbits.SPEN = 1;		// VA|[gL
	RCSTAbits.CREN = 1;		// AML
	PIE1bits.RCIE = 1;		// M荞ݗL
	PEIE	= 1;	// periferal interrupt enable
	GIE		= 1;	// global interrupt enable

	uint32_t	i,ivalR,ivalG,ivalB,ivalBR;
	uint32_t	paraR,paraG,paraB;

	while(1) {
		if(recend==1) {	// σoCgAM?
			uint8_t cmdByte = dtbufb[0];
			if(cmdByte==0xff) {	// chf[^ύXR}hH -> p~
#ifdef	DEBUG
				TXREG = dtbufb[1];	// for debug
#endif
//				chChar = dtbufb[1] & 0x7f;
//				writeEEPROM(chChar);	// Vchf[^i[
				recend = 0;
			} else if((cmdByte & ~0x40)==(uint8_t)(chChar & 0xff)) {	// chf[^1oCgڂvꍇ
				ivalBR = dtbufb[1] & 0x7f;			// Pxi0?127j
				if ((cmdByte & 0x40)!=0) {			// FI[hH 
MON = 1;
					uint8_t colNo = dtbufb[2] & 0x3f;
					paraR = ColorData[colNo][0];
					paraG = ColorData[colNo][1];
					paraB = ColorData[colNo][2];
				} else {	// J[R[hݒ胂[h
MON = 1;
					paraR = dtbufb[2] & 0x7f;		// R邳␳14bit
					paraG = dtbufb[3] & 0x7f;		// G邳␳14bit
					paraB = dtbufb[4] & 0x7f;		// B邳␳14bit
				}
				ivalR = (paraR*paraR*paraR*ivalBR)>>16;
				ivalG = (paraG*paraG*paraG*ivalBR)>>16;
				ivalB = (paraB*paraB*paraB*ivalBR)>>16;
				PWM1DC = ivalR & 0xffff;
				PWM2DC = (ivalG+VOFF1) & 0xffff;	// Phase̕APulsêŃItZbglZ
				PWM3DC = (ivalB+VOFF2) & 0xffff;	// Phase̕APulsêŃItZbglZ
				PWM1LDCONbits.LDA = 1;	// PWM1 ReLoad
				PWM2LDCONbits.LDA = 1;	// PWM2 ReLoad
				PWM3LDCONbits.LDA = 1;	// PWM3 ReLoad
				recend=0;
MON = 0;
			}
#ifdef	DEBUG
					TXREG = chChar;	// for debug
#endif
		}
	}
}